﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CAct曲パネル一覧 : CActivity
	{
		public int n現在の選択曲番号
		{
			get
			{
				int n = this.n現在の中心曲番号 + ( this.nカーソルY位置0to2 - 1 );
				while( n < 0 )
					n += Global.Users.SelectedUser.Songs.Count;

				return n;
			}
		}

		protected override void Onデバイスリソースの作成()
		{
			Global.tデバイスをロックして処理を行う( ( hDevice ) => {
				this.txパネル枠 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\StageSelect SongBoard.png" ) );
			} );
		}
		protected override void Onデバイスリソースの解放()
		{
			if( this.txパネル枠 != null )
				this.txパネル枠.Dispose();
		}
		protected override void On活性化()
		{
			//this.nカーソルY位置0to2 = 1;		前回の値を引き継ぐので初期化しない。
			//this.n現在の中心曲番号 = 0;		同上。
			this.n目標のスクロールカウンタ = 0;
			this.n現在のスクロールカウンタ = 0;
			this.mスクロールアニメ用一定間隔処理 = new C一定間隔処理();
		}
		protected override void On非活性化()
		{
			if( this.mスクロールアニメ用一定間隔処理 != null )
				this.mスクロールアニメ用一定間隔処理.Dispose();
		}
		protected override int On進行()
		{
			if( Global.Users.SelectedUser != null )
			{
				#region [ 曲パネルのスクロールの進行と選択曲の変更。]
				//-----------------
				if( Global.Users.SelectedUser != null && Global.Users.SelectedUser.Songs.Count > 0 )
				{
					this.mスクロールアニメ用一定間隔処理.t進行( 1, () => {

						int n加速度 = 1;
						int n残距離 = Math.Abs( (int) ( this.n目標のスクロールカウンタ - this.n現在のスクロールカウンタ ) );

						#region [ 残距離が遠いほどスクロールを速くする（＝n加速度を多くする）。]
						//-----------------
						if( n残距離 <= 100 )
						{
							n加速度 = 1;
						}
						else if( n残距離 <= 300 )
						{
							n加速度 = 2;
						}
						else if( n残距離 <= 500 )
						{
							n加速度 = 3;
						}
						else
						{
							n加速度 = 4;
						}
						//-----------------
						#endregion

						#region [ 加速度を加算し、現在のスクロールカウンタを目標のスクロールカウンタまで近づける。 ]
						//-----------------
						if( this.n現在のスクロールカウンタ < this.n目標のスクロールカウンタ )		// (A) 正の方向に未達の場合：
						{
							this.n現在のスクロールカウンタ += n加速度;								// 　　カウンタを正方向に移動する。

							if( this.n現在のスクロールカウンタ > this.n目標のスクロールカウンタ )
								this.n現在のスクロールカウンタ = this.n目標のスクロールカウンタ;	// 　　到着！スクロール停止！
						}
						else if( this.n現在のスクロールカウンタ > this.n目標のスクロールカウンタ )	// (B) 負の方向に未達の場合：
						{
							this.n現在のスクロールカウンタ -= n加速度;								// 　　カウンタを負方向に移動する。

							if( this.n現在のスクロールカウンタ < this.n目標のスクロールカウンタ )	// 　　到着！スクロール停止！
								this.n現在のスクロールカウンタ = this.n目標のスクロールカウンタ;
						}
						//-----------------
						#endregion

						if( this.n現在のスクロールカウンタ >= 100 )		// １行＝100カウント。
						{
							#region [ 曲マトリックスを右から左へ１列シフトする。]
							//-----------------
							//if( this.sdカーソル移動音 != null )
							//  this.sdカーソル移動音.t先頭から再生する();

							this.n現在のスクロールカウンタ -= 100;
							this.n目標のスクロールカウンタ -= 100;


							// 中心曲をひとつ左へ。

							this.n現在の中心曲番号 = this.n指定位置の曲番号を返す( x0to6: 2, y0to2: 1 );
							

							// 選択曲変更。
							
							Global.Users.SelectedUser.Songs.SelectedSongIndex = this.n現在の選択曲番号;
							//-----------------
							#endregion
						}
						else if( this.n現在のスクロールカウンタ <= -100 )
						{
							#region [ 曲マトリックスを左から右へ１列シフトする。]
							//-----------------
							//if( this.sdカーソル移動音 != null )
							//	this.sdカーソル移動音.t先頭から再生する();

							this.n現在のスクロールカウンタ += 100;
							this.n目標のスクロールカウンタ += 100;


							// 中心曲をひとつ右へ。

							this.n現在の中心曲番号 = this.n指定位置の曲番号を返す( x0to6: 4, y0to2: 1 );


							// 選択曲変更。

							Global.Users.SelectedUser.Songs.SelectedSongIndex = this.n現在の選択曲番号;
							//-----------------
							#endregion
						}

					} );
				}
				//-----------------
				#endregion


				// 以下のキーは、曲が１曲以上ある場合のみ有効。

				if( Global.Users.SelectedUser.Songs.Count > 0 )
				{
					#region [ 右矢印 → 曲マトリックスを右へスクロール ]
					//-----------------
					if( Global.Input.Keyboard.bキーが押された( Key.RightArrow ) )
					{
						// 最小でも-800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
						this.n目標のスクロールカウンタ = Math.Max( this.n目標のスクロールカウンタ - 100, -800 );
					}
					//-----------------
					#endregion
					#region [ 左矢印 → 曲マトリックスを左へスクロール ]
					//-----------------
					if( Global.Input.Keyboard.bキーが押された( Key.LeftArrow ) )
					{
						// 最大でも+800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
						this.n目標のスクロールカウンタ = Math.Min( this.n目標のスクロールカウンタ + 100, 800 );
					}
					//-----------------
					#endregion
					#region [ 上矢印 → 曲カーソルを上に移動。]
					//-----------------
					if( Global.Input.Keyboard.bキーが押された( Key.UpArrow ))
					{
						if( this.nカーソルY位置0to2 > 0 )
						{
//							if( this.sdカーソル移動音 != null )
//								this.sdカーソル移動音.t先頭から再生する();

							this.nカーソルY位置0to2--;
						}
						else
						{
							this.nカーソルY位置0to2 = 2;

							// 最大でも+800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
							this.n目標のスクロールカウンタ = Math.Min( this.n目標のスクロールカウンタ + 100, 800 );
						}

						// 選択曲変更。

						Global.Users.SelectedUser.Songs.SelectedSongIndex = this.n現在の選択曲番号;
					}
					//-----------------
					#endregion
					#region [ 下矢印 → 曲カーソルを下に移動。]
					//-----------------
					if( Global.Input.Keyboard.bキーが押された( Key.DownArrow ))
					{
						if( this.nカーソルY位置0to2 < 2 )
						{
//							if( this.sdカーソル移動音 != null )
//								this.sdカーソル移動音.t先頭から再生する();

							this.nカーソルY位置0to2++;
						}
						else
						{
							this.nカーソルY位置0to2 = 0;

							// 最小でも-800まで。（連打をやめると、慣性で最大8列スクロールして停止する。）
							this.n目標のスクロールカウンタ = Math.Max( this.n目標のスクロールカウンタ - 100, -800 );
						}
					}

					// 選択曲変更。

					Global.Users.SelectedUser.Songs.SelectedSongIndex = this.n現在の選択曲番号;
					//-----------------
					#endregion
					#region [ Enter → 曲決定。]
					//-----------------
					if( Global.Input.Keyboard.bキーが押された( Key.Return ) )
						return (int) E進行結果.曲決定;
					//-----------------
					#endregion
				}
			}

			return (int) E進行結果.継続;
		}
		protected override void On描画( IntPtr hDevice )
		{
			// 曲パネル一覧を描画する。

			for( int i = 0; i < 7 * 3 + 1; i++ )
			{
				int mx = i / 3;	// パネル位置X 上:0～2:下
				int my = i % 3;	// パネル位置Y 左:0～6:右

				#region [ 左に移動中なら最左列、右に移動中なら最右列は表示しない。]
				//-----------------
				if( ( mx == 0 && this.n現在のスクロールカウンタ < 0 ) ||
					( mx == 6 && this.n現在のスクロールカウンタ > 0 ) )
				{
					continue;
				}
				//-----------------
				#endregion

				#region [ 選択されているパネルは一番最後に表示する。]
				//-----------------
				if( mx == 3 && my == this.nカーソルY位置0to2 )		// 選択パネルは描画せずにスキップし、一番最後に回す。
					continue;

				if( i == 7 * 3 + 1 - 1 )			// 一番最後。
				{
					mx = 3;							// Xは常に中央
					my = this.nカーソルY位置0to2;	// Yは0～2
				}
				//-----------------
				#endregion

				#region [ サムネイルとパネル枠を描画。]
				//-----------------
				{
					int dx = ( this.n現在のスクロールカウンタ == 0 ) ? 0 : ( ( this.n現在のスクロールカウンタ < 0 ) ? -1 : +1 );
					float f割合 = Math.Abs( this.n現在のスクロールカウンタ ) / 100.0f;
					float f拡大率 = ( mx == 3 && my == this.nカーソルY位置0to2 ) ? 1.25f : 1.0f;
					Matrix mat;
					Matrix matY軸回転 = Matrix.RotationY( this.st曲パネルの中心点[ mx, my ].rotY + ( this.st曲パネルの中心点[ mx + dx, my ].rotY - this.st曲パネルの中心点[ mx, my ].rotY ) * f割合 );
					Matrix mat平行移動 = Matrix.Translation(
								( this.st曲パネルの中心点[ mx, my ].x + (int) ( ( this.st曲パネルの中心点[ mx + dx, my ].x - this.st曲パネルの中心点[ mx, my ].x ) * f割合 ) ),
								( this.st曲パネルの中心点[ mx, my ].y + (int) ( ( this.st曲パネルの中心点[ mx + dx, my ].y - this.st曲パネルの中心点[ mx, my ].y ) * f割合 ) ),
								( this.st曲パネルの中心点[ mx, my ].z + (int) ( ( this.st曲パネルの中心点[ mx + dx, my ].z - this.st曲パネルの中心点[ mx, my ].z ) * f割合 ) ) );

					if( Global.Users.SelectedUser != null )
					{
						int n曲番号 = this.n指定位置の曲番号を返す( mx, my );
						Song song = Global.Users.SelectedUser.Songs[ n曲番号 ];

						if( song.bサムネイルBitmap作成完了.Get() && !song.bサムネイルTexture作成完了.Get() )	// Bitmap が完了して Texture がまだなら今作る。
							song.tサムネイルのTextureを作成する( hDevice );

						if( song.txサムネイル画像 != null )
						{
							mat = Matrix.Identity;
							mat *= Matrix.Scaling(
								f拡大率 * ( 322f / (float) song.txサムネイル画像.sz画像サイズ.Width ),
								f拡大率 * ( 182f / (float) song.txサムネイル画像.sz画像サイズ.Height ),
								1.0f );
							mat *= matY軸回転;
							mat *= mat平行移動;

							song.txサムネイル画像.t3D描画( hDevice, mat );
						}
					}

					if( this.txパネル枠 != null )
					{
						mat = Matrix.Identity;
						mat *= Matrix.Scaling( f拡大率, f拡大率, 1.0f );
						mat *= matY軸回転;
						mat *= mat平行移動;

						this.txパネル枠.t3D描画( hDevice, mat );
					}
				}
				//-----------------
				#endregion
			}
		}

		private int n現在の中心曲番号 = 0;			// CApplication.Users.SelectedUser.Songs のインデックス番号。選択曲とは限らない（nカーソルY位置0to2 による）。
		private int nカーソルY位置0to2 = 1;
		private int n現在のスクロールカウンタ = 0;	// 右へスクロール:-800 ～ +800:右へスクロール
		private int n目標のスクロールカウンタ = 0;	// 右へスクロール:-800 ～ +800:右へスクロール
		private C一定間隔処理 mスクロールアニメ用一定間隔処理 = null;

		private CTexture txパネル枠 = null;

		// 3行7列 [7,3]
		// △□□○□□△　　○が中心曲。（選択曲とは限らない）
		// △□□○□□△　　■が選択曲。（常に中心曲３つのうちのどれかである）
		// △□□■□□△　　△は画面外。
		private struct ST中心点 { public float x, y, z, rotY; }
		private readonly ST中心点[ , ] st曲パネルの中心点 = new ST中心点[ 7, 3 ] {
			#region [ 原寸での3D配置。実は円弧配列になってない ]
			//-----------------
			{
				new ST中心点() { x = -936f, y = 350f, z = -520f, rotY = -1f },
				new ST中心点() { x = -936f, y = 100f, z = -520f, rotY = -1f },
				new ST中心点() { x = -936f, y = -150f, z = -520f, rotY = -1f },
			},
			{
				new ST中心点() { x = -684f, y = 350f, z = -220f, rotY = -0.65f },
				new ST中心点() { x = -684f, y = 100f, z = -220f, rotY = -0.65f },
				new ST中心点() { x = -684f, y = -150f, z = -220f, rotY = -0.65f },
			},
			{
				new ST中心点() { x = -360f, y = 350f, z = -55f, rotY = -0.3f },
				new ST中心点() { x = -360f, y = 100f, z = -55f, rotY = -0.3f },
				new ST中心点() { x = -360f, y = -150f, z = -55f, rotY = -0.3f },
			},
			{
				new ST中心点() { x = 0f, y = 350f, z = 0f, rotY = 0f },
				new ST中心点() { x = 0f, y = 100f, z = 0f, rotY = 0f },
				new ST中心点() { x = 0f, y = -150f, z = 0f, rotY = 0f },
			},
			{
				new ST中心点() { x = 360f, y = 350f, z = -55f, rotY = 0.3f },
				new ST中心点() { x = 360f, y = 100f, z = -55f, rotY = 0.3f },
				new ST中心点() { x = 360f, y = -150f, z = -55f, rotY = 0.3f },
			},
			{
				new ST中心点() { x = 684f, y = 350f, z = -220f, rotY = 0.65f },
				new ST中心点() { x = 684f, y = 100f, z = -220f, rotY = 0.65f },
				new ST中心点() { x = 684f, y = -150f, z = -220f, rotY = 0.65f },
			},
			{
				new ST中心点() { x = 936f, y = 350f, z = -520f, rotY = 1f },
				new ST中心点() { x = 936f, y = 100f, z = -520f, rotY = 1f },
				new ST中心点() { x = 936f, y = -150f, z = -520f, rotY = 1f },
			},
			//-----------------
			#endregion
		};

		private int n指定位置の曲番号を返す( int x0to6, int y0to2 )
		{
			if( Global.Users.SelectedUser == null )
				return -1;

			int n総曲数 = Global.Users.SelectedUser.Songs.Count;
			int nX差分 = x0to6 - 3;		// -3 ... +3
			int nY差分 = y0to2 - 1;		// -1 ... +1 

			int n曲番号 = this.n現在の中心曲番号 + ( nX差分 * 3 ) + nY差分;

			while( n曲番号 < 0 )
				n曲番号 += n総曲数;

			return ( n曲番号 % n総曲数 );	// 0 ... n総曲数-1
		}


		// 設計時のみ使用する。本番では使わない。
		private void t設計時用の座標調整表示( IntPtr hDevice )
		{

#if DEBUG
			float cx = 0f;		// 基準点：中央枠の中央位置
			float cy = 100f;

			float hd = 250f;			// 枠の間隔・縦
			float wd1 = 360f;			// 枠の間隔・横＋１
			float wd2 = 360f * 1.9f;		// 枠の間隔・横＋２
			float wd3 = 360f * 2.6f;		// 枠の間隔・横＋３

			float p1z = -55f;	// ＋１のZ軸移動量
			float p2z = -220f;	// ＋２のZ軸移動量
			float p3z = -520f;	// ＋３のZ軸移動量

			float rot1y = 0.3f;		// ＋１のY軸回転量（rad）
			float rot2y = 0.65f;	// ＋２のY軸回転量（rad）
			float rot3y = 1f;		// ＋３のY軸回転量（rad）

			Matrix mat;

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot3y );
			mat *= Matrix.Translation( cx - wd3, cy + hd, p3z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋３・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd3, cy + hd, p3z, -rot3y ) );


			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot3y );
			mat *= Matrix.Translation( cx - wd3, cy, p3z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋３・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd3, cy, p3z, -rot3y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot3y );
			mat *= Matrix.Translation( cx - wd3, cy - hd, p3z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋３・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd3, cy - hd, p3z, -rot3y ) );


			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot2y );
			mat *= Matrix.Translation( cx - wd2, cy + hd, p2z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋２・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd2, cy + hd, p2z, -rot2y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot2y );
			mat *= Matrix.Translation( cx - wd2, cy, p2z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋２・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd2, cy, p2z, -rot2y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot2y );
			mat *= Matrix.Translation( cx - wd2, cy - hd, p2z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋２・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd2, cy - hd, p2z, -rot2y ) );


			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot1y );
			mat *= Matrix.Translation( cx - wd1, cy + hd, p1z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋１・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd1, cy + hd, p1z, -rot1y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot1y );
			mat *= Matrix.Translation( cx - wd1, cy, p1z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋１・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd1, cy, p1z, -rot1y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( -rot1y );
			mat *= Matrix.Translation( cx - wd1, cy - hd, p1z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 左＋１・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx - wd1, cy - hd, p1z, -rot1y ) );


			mat = Matrix.Identity;
			Matrix.Translation( cx, cy + hd, 0f, out mat );
			this.txパネル枠.t3D描画( hDevice, mat );	// 中央・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx, cy + hd, 0f, 0f ) );

			mat = Matrix.Translation( cx, cy, 0f );
			this.txパネル枠.t3D描画( hDevice, mat );	// 中央・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx, cy, 0f, 0f ) );

			mat = Matrix.Identity;
			Matrix.Translation( cx, cy - hd, 0f, out mat );
			this.txパネル枠.t3D描画( hDevice, mat );	// 中央・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx, cy - hd, 0f, 0f ) );


			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot1y );
			mat *= Matrix.Translation( cx + wd1, cy + hd, p1z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋１・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd1, cy + hd, p1z, rot1y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot1y );
			mat *= Matrix.Translation( cx + wd1, cy, p1z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋１・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd1, cy, p1z, rot1y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot1y );
			mat *= Matrix.Translation( cx + wd1, cy - hd, p1z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋１・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd1, cy - hd, p1z, rot1y ) );


			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot2y );
			mat *= Matrix.Translation( cx + wd2, cy + hd, p2z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋２・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd2, cy + hd, p2z, rot2y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot2y );
			mat *= Matrix.Translation( cx + wd2, cy, p2z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋２・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd2, cy, p2z, rot2y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot2y );
			mat *= Matrix.Translation( cx + wd2, cy - hd, p2z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋２・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd2, cy - hd, p2z, rot2y ) );


			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot3y );
			mat *= Matrix.Translation( cx + wd3, cy + hd, p3z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋３・上
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd3, cy + hd, p3z, rot3y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot3y );
			mat *= Matrix.Translation( cx + wd3, cy, p3z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋３・中
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd3, cy, p3z, rot3y ) );

			mat = Matrix.Identity;
			mat *= Matrix.RotationY( rot3y );
			mat *= Matrix.Translation( cx + wd3, cy - hd, p3z );
			this.txパネル枠.t3D描画( hDevice, mat );	// 右＋３・下
			Debug.WriteLine( string.Format( "new ST中心点() {{ x = {0}, y = {1}, z = {2}, rotY = {3} }},", cx + wd3, cy - hd, p3z, rot3y ) );
#endif
		}
	}
}
